/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;
import jclass.chart.ChartDataModelUpdate;
import jclass.chart.ChartDataSupport;
import jclass.chart.EditableChartable;
import jclass.chart.JCChartBundle;

public class VectorDataSource
extends ChartDataSupport
implements EditableChartable,
Serializable {
    int dataInterpretation = 0;
    double holeValue = Double.MAX_VALUE;
    boolean dataInRows = true;
    boolean autoX = false;
    String name;
    Vector pointLabels = new Vector();
    Vector seriesLabels = new Vector();
    Vector seriesNames = new Vector();
    double[][] data;
    private static final String QUOTE = "'";
    private static final String NL = "\n";
    private static final String BLANK = " ";
    private static final String COMMENT = "#";
    private static final String commentLine1 = "# " + JCChartBundle.string("jclass.chart.Key167") + "\n";
    private static final String commentLine2 = "# " + JCChartBundle.string("jclass.chart.Key168") + "\n";
    private static final String commentLine3 = "# " + JCChartBundle.string("jclass.chart.Key169") + "\n";
    private static final String commentLine4 = "# " + JCChartBundle.string("jclass.chart.Key170") + "\n";

    public VectorDataSource() {
        double[][] dArrayArray = new double[5][];
        double[] dArray = new double[5];
        dArray[1] = 1.0;
        dArray[2] = 2.0;
        dArray[3] = 3.0;
        dArray[4] = 4.0;
        dArrayArray[0] = dArray;
        dArrayArray[1] = new double[]{20.0, 22.0, 19.0, 24.0, 25.0};
        dArrayArray[2] = new double[]{8.0, 12.0, 10.0, 12.0, 15.0};
        dArrayArray[3] = new double[]{10.0, 16.0, 17.0, 15.0, 23.0};
        dArrayArray[4] = new double[]{16.0, 19.0, 15.0, 22.0, 18.0};
        this.data = dArrayArray;
        this.name = new String(JCChartBundle.string("jclass.chart.Key165"));
        int n = 0;
        while (n < this.data[0].length) {
            if (n != 0) {
                this.seriesNames.addElement(String.valueOf(JCChartBundle.string("jclass.chart.Key128")) + n);
                this.seriesLabels.addElement(String.valueOf(JCChartBundle.string("jclass.chart.Key127")) + n);
            } else {
                this.seriesNames.addElement("X " + JCChartBundle.string("jclass.chart.Key128"));
                this.seriesLabels.addElement("X " + JCChartBundle.string("jclass.chart.Key127"));
            }
            this.pointLabels.addElement(String.valueOf(JCChartBundle.string("jclass.chart.Key166")) + n);
            ++n;
        }
    }

    public VectorDataSource(double[][] dArray) {
        double[][] dArrayArray = new double[5][];
        double[] dArray2 = new double[5];
        dArray2[1] = 1.0;
        dArray2[2] = 2.0;
        dArray2[3] = 3.0;
        dArray2[4] = 4.0;
        dArrayArray[0] = dArray2;
        dArrayArray[1] = new double[]{20.0, 22.0, 19.0, 24.0, 25.0};
        dArrayArray[2] = new double[]{8.0, 12.0, 10.0, 12.0, 15.0};
        dArrayArray[3] = new double[]{10.0, 16.0, 17.0, 15.0, 23.0};
        dArrayArray[4] = new double[]{16.0, 19.0, 15.0, 22.0, 18.0};
        this.data = dArrayArray;
        this.data = dArray;
    }

    public VectorDataSource(double[][] dArray, int n) {
        double[][] dArrayArray = new double[5][];
        double[] dArray2 = new double[5];
        dArray2[1] = 1.0;
        dArray2[2] = 2.0;
        dArray2[3] = 3.0;
        dArray2[4] = 4.0;
        dArrayArray[0] = dArray2;
        dArrayArray[1] = new double[]{20.0, 22.0, 19.0, 24.0, 25.0};
        dArrayArray[2] = new double[]{8.0, 12.0, 10.0, 12.0, 15.0};
        dArrayArray[3] = new double[]{10.0, 16.0, 17.0, 15.0, 23.0};
        dArrayArray[4] = new double[]{16.0, 19.0, 15.0, 22.0, 18.0};
        this.data = dArrayArray;
        this.dataInterpretation = n;
        this.data = dArray;
    }

    void updateChart(int n, int n2, int n3) {
        try {
            ChartDataModelUpdate chartDataModelUpdate = new ChartDataModelUpdate(n, n2, n3);
            this.fireChartDataEvent(chartDataModelUpdate);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    public int getDataInterpretation() {
        return this.dataInterpretation;
    }

    public void setDataInterpretation(int n) {
        if (this.dataInterpretation == n) {
            return;
        }
        this.dataInterpretation = n;
        this.updateChart(15, 0, 0);
    }

    public boolean getDataInRows() {
        return this.dataInRows;
    }

    public void setDataInRows(boolean bl) {
        if (this.dataInRows == bl) {
            return;
        }
        this.dataInRows = bl;
        this.updateChart(16, 0, 0);
    }

    public boolean getAutoX() {
        return this.autoX;
    }

    public void setAutoX(boolean bl) {
        if (this.autoX == bl) {
            return;
        }
        this.autoX = bl;
        this.updateChart(16, 0, 0);
    }

    public double getHoleValue() {
        return this.holeValue;
    }

    public void setHoleValue(double d) {
        if (this.holeValue == d) {
            return;
        }
        this.holeValue = d;
        this.updateChart(16, 0, 0);
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
        this.updateChart(16, 0, 0);
    }

    public synchronized Object getDataItem(int n, int n2) {
        if (this.data == null) {
            return null;
        }
        Double d = null;
        try {
            if (this.autoX && this.isXRow(n)) {
                d = new Double(n2);
            } else {
                Point point = this.getDataIndex(n, n2);
                double d2 = this.data[point.x][point.y];
                if (this.holeValue != Double.MAX_VALUE && d2 == this.holeValue) {
                    d2 = Double.MAX_VALUE;
                }
                d = new Double(d2);
            }
        }
        catch (Exception exception) {
            d = null;
        }
        return d;
    }

    public synchronized boolean setDataItem(int n, int n2, Object object) {
        if (this.data == null) {
            return false;
        }
        boolean bl = true;
        try {
            if (this.autoX && this.isXRow(n)) {
                bl = false;
            } else {
                Point point = this.getDataIndex(n, n2);
                this.data[point.x][point.y] = ((Number)object).doubleValue();
            }
            this.updateChart(0, n, n2);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    boolean isXRow(int n) {
        boolean bl = false;
        if (this.dataInterpretation == 0) {
            if (n == 0) {
                bl = true;
            }
        } else if (this.dataInterpretation == 1 && n % 2 == 0) {
            bl = true;
        }
        return bl;
    }

    int getXRowDataIndex(int n) {
        if (!this.autoX) {
            return n;
        }
        if (this.dataInterpretation == 0) {
            return n - 1;
        }
        if (this.dataInterpretation == 1) {
            return n / 2;
        }
        return n;
    }

    Point getDataIndex(int n, int n2) {
        int n3 = this.autoX ? this.getXRowDataIndex(n) : n;
        int n4 = 0;
        int n5 = 0;
        if (this.dataInRows) {
            n4 = n3;
            n5 = n2;
        } else {
            n4 = n2;
            n5 = n3;
        }
        return new Point(n4, n5);
    }

    public synchronized Vector getRow(int n) {
        if (this.data == null) {
            return null;
        }
        Vector vector = null;
        try {
            if (this.autoX && this.isXRow(n)) {
                if (this.dataInterpretation == 0) {
                    vector = this.makeXValues(this.data[n / 2].length);
                } else if (this.dataInterpretation == 1) {
                    vector = this.makeXValues(this.data.length);
                }
            } else {
                int n2;
                int n3 = n2 = this.autoX ? this.getXRowDataIndex(n) : n;
                vector = this.dataInRows ? this.makeVector(this.data[n2]) : this.makeVector(this.data, n2);
            }
        }
        catch (Exception exception) {
            vector = null;
        }
        return vector;
    }

    Vector makeXValues(int n) {
        Vector<Double> vector = new Vector<Double>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(new Double(n2));
            ++n2;
        }
        return vector;
    }

    Vector makeVector(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        Vector<Double> vector = new Vector<Double>();
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d = dArray[n];
            if (this.holeValue != Double.MAX_VALUE && d == this.holeValue) {
                d = Double.MAX_VALUE;
            }
            vector.addElement(new Double(d));
            ++n;
        }
        return vector;
    }

    Vector makeVector(double[][] dArray, int n) {
        if (dArray == null) {
            return null;
        }
        Vector<Double> vector = new Vector<Double>();
        double d = 0.0;
        int n2 = 0;
        while (n2 < dArray.length) {
            d = dArray[n2][n];
            if (this.holeValue != Double.MAX_VALUE && d == this.holeValue) {
                d = Double.MAX_VALUE;
            }
            vector.addElement(new Double(d));
            ++n2;
        }
        return vector;
    }

    public int getNumRows() {
        if (this.data == null) {
            return 0;
        }
        if (this.dataInRows) {
            if (this.autoX) {
                if (this.dataInterpretation == 0) {
                    return this.data.length + 1;
                }
                return this.data.length * 2;
            }
            return this.data.length;
        }
        int n = this.maxColumns();
        if (this.autoX) {
            if (this.dataInterpretation == 0) {
                return n + 1;
            }
            return n * 2;
        }
        return n;
    }

    int maxColumns() {
        int n = 0;
        if (this.data == null) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.data.length) {
            if (this.data[n2].length > n) {
                n = this.data[n2].length;
            }
            ++n2;
        }
        return n;
    }

    public String[] getPointLabels() {
        if (this.pointLabels == null) {
            return null;
        }
        Object[] objectArray = new String[this.pointLabels.size()];
        this.pointLabels.copyInto(objectArray);
        return objectArray;
    }

    public void setPointLabels(String[] stringArray) {
        this.pointLabels = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            this.pointLabels.addElement(stringArray[n]);
            ++n;
        }
        this.updateChart(17, 0, 0);
    }

    public String getSeriesName(int n) {
        String string;
        try {
            string = (String)this.seriesNames.elementAt(n);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public void setSeriesNames(String[] stringArray) {
        this.seriesNames = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            this.seriesNames.addElement(stringArray[n]);
            ++n;
        }
        this.updateChart(18, 0, 0);
    }

    public String getSeriesLabel(int n) {
        String string;
        try {
            string = (String)this.seriesLabels.elementAt(n);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public void setSeriesLabels(String[] stringArray) {
        this.seriesLabels = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            this.seriesLabels.addElement(stringArray[n]);
            ++n;
        }
        this.updateChart(19, 0, 0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.updateChart(20, 0, 0);
    }

    protected String buildDataSourceString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.data.length;
        int n2 = this.data[0].length;
        if (this.getDataInterpretation() == 0) {
            stringBuffer.append(commentLine1);
            stringBuffer.append(commentLine2);
            stringBuffer.append(commentLine3);
            stringBuffer.append(commentLine4);
            stringBuffer.append("ARRAY ");
            if (this.getName() != null) {
                stringBuffer.append(QUOTE + this.getName() + QUOTE + BLANK);
            } else {
                stringBuffer.append("'' ");
            }
            stringBuffer.append(String.valueOf(n - 1) + BLANK + n2 + BLANK + NL);
            String[] stringArray = this.getPointLabels();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3] != null) {
                    stringBuffer.append(QUOTE + stringArray[n3] + QUOTE + BLANK);
                } else {
                    stringBuffer.append("'' ");
                }
                ++n3;
            }
            stringBuffer.append(NL);
            int n4 = 0;
            while (n4 < n) {
                Vector vector = this.getRow(n4);
                if (this.getSeriesLabel(n4) != null) {
                    stringBuffer.append(QUOTE + this.getSeriesLabel(n4) + QUOTE + BLANK);
                } else {
                    stringBuffer.append("'' ");
                }
                int n5 = 0;
                while (n5 < n2) {
                    stringBuffer.append(String.valueOf((Double)vector.elementAt(n5)) + BLANK);
                    ++n5;
                }
                stringBuffer.append(NL);
                ++n4;
            }
            stringBuffer.append(NL);
        }
        return stringBuffer.toString();
    }
}

